\version "2.16.0"

\paper {
  between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 2))
  left-margin = 1.3\cm
  line-width = 19.6\cm
  print-page-number = false
  top-margin = 5\mm
  ragged-last-bottom=##f
  system-count = #4
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Cât de mărit"
  subtitle = "Коль славен"
  subsubtitle = "(variantă)"
  composer =  \markup \center-column { "Dimitri Stepanovici Bortnianski (1751 - 1825)"
  	  	\small "Armonizare: Ioan Cartu (1820 - 1875)" }
  tagline = ""
  meter = "Andante"
}

global = {
  \key c \major
  \time 3/4
  \autoBeamOff
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Cât de mă -- rit es -- te Dom -- nul în Si -- on, 
  nu poa -- te lim -- ba a tâl -- cu -- i. 
  Ma -- re es -- te Dom -- nul in Cer pe Tron
  şi pâ -- nă -- ntr-un fir de iar -- bă pe pă -- mânt.
  
  Ma -- re eşti, pre -- tu -- tin -- de -- nea, Doa -- mne,
  pre -- tu -- tin -- de -- nea eşti mă -- rit,
  în zi, in noa -- pte, cu stră -- lu -- ci -- re.
  Ma -- re re.
}

sopMusic = \relative c'' {
  \partial 4
  	g4^\mf 
  e2 f4
  g2 c8 c8
  d4 c4 b8 b8
  c2\fermata
  g4
  a4( c4) a4
  g2 e4
  g4 f4 e4
  d2 g8 g8  
  e2 f4
  g2 c8 c8
  d4( c4) b4
  c2\breathe g4
  a4 c4 a4
  g2 e4
  a4. g8 f8 e8
  d4. b'8\rest g8 g8
  
  \repeat volta 2 {
    b2( g4)
    c2 g4
    e'4 d4 c4
    c2 b4
    c4( b4) a4
    g2 e8 e8
    a4.( g8) f8( e8)
    d2 g4
    b2 g4
    c2 g4
    e'4 d4 c4
    b2.
  }
  \alternative {
  	  {c2 g8 g8 }
  	  {c2. }
  }
}

altMusic = \relative c' {
  \partial 4
  	e4
  c2 d4
  e2 e8 e8
  f4 e4 d8 d8
  e2 e4 
  f4( a4) f4
  e2 c4
  e4 d4 c4
  b2 g'8 g8
  c,2 d4
  e2 e8 e8
  f4( e4) d4
  e2 e4
  f4 a4 f4
  e2 c4
  f4. e8 d8 c8
  b4. b'8\rest g8 g8
  
    \repeat volta 2 {
    f2( g4)
    e2 e4
    g4 f4 e4
    e2 d4
    e2 d4
    e2 c8 c8
    f4.( e8) d8( c8)
    b2 g'4
    g2 g4
    e2 e4
    g4 f4 e4
    d2( f4)
    }
    \alternative {
  	  {e2 g8 g8 }
  	  {e2. }
  }
}  	

tenorMusic = \relative c' {
  \partial 4
  	c4
  c2 c4
  c2 g8 g8
  g4 g4 g8 g8
  g2 c4
  c2 c4
  c2 c4
  g4 g4 g4
  g2 g8 g8
  g2 g4
  g2 g8 g8
  g2 g4
  g2 c4
  c4 c4 c4
  c2 c4
  c4. c8 g8 g8
  g4. d8\rest g8 g8
  
   \repeat volta 2 {
   g2.
   g2 g4
   g4 g4 g4
   g2 g4
   g2 g4
   g2 g8 g8
   f2 g4
   g2 g4
   g2 g4
   g2 g4
   g4 g4 g4
   g2.
   }
   \alternative {
  	  {g2 g8 g8 }
  	  {g2. }
  }
}

bassMusic = \relative c {
  \clef bass
  \partial 4
	c4
  c2 c4
  c2 c8 c8
  g'4 g4 g8 g8
  c,2 c4
  f2 f4
  c2 c4
  g'4 g4 g4
  g2 g8 g8
  c,2 c4
  c2 c8 c8
  g'2 g4
  c,2\breathe c4
  f4 f4 f4
  c2 c4
  f4. f8 g8 g8
  g4. d8\rest g8 g8
  
  \repeat volta 2 {
    d2.
    c2 c4
    c4 b4 c4
    g'2 g4
    c,4( e4) f4
    c2 c8 c8
    f2 g4
    g2 g4
    d2 d4
    c2 c4
    g'4 g4 g4
    g2.
  }
  \alternative {
  	  { c,2 g'8 g8 }
  	  { c,2. }
  }
}

myScore = \new Score <<
  \new ChoirStaff <<
     \new Staff <<
      \new Voice { \voiceOne \global \sopMusic }
      \new Voice { \voiceTwo \global \altMusic }
      \addlyrics { \womenWords }
     >>

     \new Staff <<
      \clef bass
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
     >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \context { \Score tempoWholesPerMinute = #(ly:make-moment 60 4) }
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

 \score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}

